#include <bits/stdc++.h>
using namespace std;
using ll = long long;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, Q;
    cin >> N >> Q;
    vector<int> P(N), pos(N);
    for (int i = 0; i < N; i++) {
        cin >> P[i];
        pos[P[i]] = i;
    }

    // Compute initial breaks
    ll breaks = 0;
    for (int v = 0; v < N-1; v++) {
        if (pos[v+1] < pos[v]) breaks++;
    }

    // Output initial cost
    cout << breaks << '\n';

    while (Q--) {
        int i, j;
        cin >> i >> j;
        int a = P[i], b = P[j];
        
        // Collect unique affected pairs
        vector<pair<int,int>> pairs;
        auto add_pair = [&](int u, int v) {
            if (u >= 1 && v >= 1 && u <= N && v <= N && abs(u - v) == 1) {
                int x = min(u, v);
                pairs.emplace_back(x, x+1);
            }
        };
        add_pair(a-1, a);
        add_pair(a, a+1);
        add_pair(b-1, b);
        add_pair(b, b+1);
        sort(pairs.begin(), pairs.end());
        pairs.erase(unique(pairs.begin(), pairs.end()), pairs.end());

        // Remove old breaks
        for (auto &pr : pairs) {
            int u = pr.first, v = pr.second;
            if (pos[v] < pos[u]) breaks--;
        }

        // Perform swap
        swap(P[i], P[j]);
        swap(pos[a], pos[b]);

        // Add new breaks
        for (auto &pr : pairs) {
            int u = pr.first, v = pr.second;
            if (pos[v] < pos[u]) breaks++;
        }

        // Output current cost
        cout << breaks << '\n';
    }

    return 0;
}